-- Written by Dominic Feira
-- Copyright 2004, Ambrosia Software, Inc.
on wireTapCalendarName()
	return ("WireTap Studio Sessions" as Unicode text)
end wireTapCalendarName

-- launch iCal
-- returns: nothing
on launchiCal()
	launch application "iCal"
end launchiCal

on debugDialog(message)
	display dialog message
end debugDialog

on wireTapCalendarExists()
	set calendarName to wireTapCalendarName()
	tell application "iCal"
		set locWireTapCalendars to every calendar whose title is calendarName
	end tell
	if (count of locWireTapCalendars) > 0 then
		return true
	end if
	return false
end wireTapCalendarExists

-- creates the wiretap calendar
-- returns: nothing
on createWireTapCalendar()
	if not wireTapCalendarExists() then
		set calendarName to wireTapCalendarName()
		tell application "iCal"
			make new calendar with properties {name:calendarName}
		end tell
	end if
end createWireTapCalendar

-- removes the wiretap calendar
-- returns: nothing
on removeWireTapCalendar()
	if wireTapCalendarExists() then
		set calendarName to wireTapCalendarName()
		tell application "iCal"
			delete (first calendar whose title is calendarName)
		end tell
	end if
end removeWireTapCalendar

-- returns the wiretap calendar
on getWireTapCalendar()
	set calendarName to wireTapCalendarName()
	launchiCal()
	tell application "iCal"
		set locWireTapCalendars to every calendar whose title is calendarName
		return first calendar whose title is calendarName
	end tell
end getWireTapCalendar


on convertMonthToNumber(monthIn)
	if monthIn is equal to January then
		return 1
	end if
	if monthIn is equal to February then
		return 2
	end if
	if monthIn is equal to March then
		return 3
	end if
	if monthIn is equal to April then
		return 4
	end if
	if monthIn is equal to May then
		return 5
	end if
	if monthIn is equal to June then
		return 6
	end if
	if monthIn is equal to July then
		return 7
	end if
	if monthIn is equal to August then
		return 8
	end if
	if monthIn is equal to September then
		return 9
	end if
	if monthIn is equal to October then
		return 10
	end if
	if monthIn is equal to November then
		return 11
	end if
	if monthIn is equal to December then
		return 12
	end if
	return 0
end convertMonthToNumber

-- converts a date to our format: year, month, day, time
on convertDateToNumberList(theDate)
	try
		set theResult to {(year of theDate), ((month of theDate) as number), ((day of theDate) as number), (time of theDate)}
	on error
		set theResult to {(year of theDate), convertMonthToNumber((month of theDate)), ((day of theDate) as number), (time of theDate)}
	end try
end convertDateToNumberList


-- returns a list of wiretap events
on getWireTapEvents()
	set calendarName to wireTapCalendarName()
	tell application "iCal"
		return every event in (first calendar whose title is calendarName)
	end tell
end getWireTapEvents

-- get the event that has the specified uniqueID
on getEventWithUID(uniqueID)
	set wireTapEvents to getWireTapEvents()
	repeat with currentEvent in wireTapEvents
		tell application "iCal"
			set eventID to uid of currentEvent
		end tell
		if ((uniqueID as Unicode text) is equal to (eventID as Unicode text)) then
			tell application "iCal"
				return currentEvent
			end tell
		end if
	end repeat
	return "not found"
end getEventWithUID

-- get all of the events that have an open file alarm that references the filePath specified
on getEventsWithPath(pathIn)
	set answer to {}
	set wireTapEvents to getWireTapEvents()
	repeat with currentEvent in wireTapEvents
		tell application "iCal"
			set curPath to filepath of (open file alarm of currentEvent)
			if (curPath as Unicode text) is equal to (pathIn as Unicode text) then
				log currentEvent
				set answer to answer & {currentEvent}
			end if
		end tell
	end repeat
	return answer
end getEventsWithPath

-- remove all of the events that have an alarm that opens the specified file
-- there is a weird bug in iCal applescript, so we have to work around it...this is ugly, prepare yourself
on removeEventsWithPath(filePath)
	repeat
		set removeEvents to getEventsWithPath(filePath)
		if removeEvents is equal to {} then
			exit repeat
		end if
		actualRemovewithPath(filePath)
	end repeat
end removeEventsWithPath

on actualRemovewithPath(filePath)
	try
		set removeEvents to getEventsWithPath(filePath)
		repeat with currentEvent in removeEvents
			tell application "iCal"
				log description of currentEvent
				delete currentEvent
			end tell
		end repeat
	on error number num
	end try
end actualRemovewithPath

on removeEventWithUID(uniqueID)
	launchiCal()
	with timeout of 2 seconds
		set removeEvent to getEventWithUID(uniqueID)
		tell application "iCal"
			delete removeEvent
		end tell
	end timeout
end removeEventWithUID

-- remove old events from iCal
on removeOldEvents(threshold)
	set wireTapEvents to getWireTapEvents()
	set limitDate to (current date) - threshold * days
	
	repeat with currentEvent in wireTapEvents
		tell application "iCal"
			set eventUID to (uid of currentEvent)
			set eventDate to (start date of currentEvent)
			set eventRecurrence to (recurrence of currentEvent)
		end tell
		
		if (eventDate < limitDate) and eventRecurrence is "" then
			tell application "iCal"
				delete currentEvent
			end tell
		end if
		
	end repeat
end removeOldEvents

on updateEventWithUID(eventUID, eventSummary, eventTitle)
	set calendarName to wireTapCalendarName()
	set changeMe to getEvent(eventUID)
	tell application "iCal"
		set summary of changeMe to eventSummary
		set description of changeMe to eventTitle
	end tell
end updateEventWithUID

on updateEventsWithPath(path, eventSummary, eventTitle)
	set updateEvents to getEventsWithPath(path)
	repeat with currentEvent in updateEvents
		tell application "iCal"
			set summary of currentEvent to eventSummary
			set description of currentEvent to eventTitle
		end tell
	end repeat
end updateEventsWithPath

on makeNewEvent(eventTitle, eventSummary, openFilePath)
	set calendarName to wireTapCalendarName()
	launchiCal()
	-- start time: 24 hours from now
	-- end time: 1 hour later
	set eventStDate to ((current date) + 1 * hours)
	set eventEndDate to (eventStDate + 1 * hours)
	log eventStDate
	tell application "iCal"
		activate
		set newEvent to (make new event at end of events of (first calendar whose title is calendarName) with properties {summary:(eventSummary as Unicode text), start date:eventStDate, end date:eventEndDate, description:eventTitle})
		make new open file alarm at end of open file alarms of newEvent with properties {trigger interval:-2, filepath:(openFilePath as Unicode text)}
		show newEvent
		
		set startDate to start date of newEvent
		set endDate to end date of newEvent
	end tell
	
	set startTranslated to convertDateToNumberList(startDate)
	set endTranslated to convertDateToNumberList(endDate)
	
	tell application "iCal"
		return {(uid of newEvent), startTranslated, endTranslated, ((recurrence of newEvent) as Unicode text), ((filepath of (open file alarm of newEvent)) as Unicode text)}
	end tell
end makeNewEvent

on makeneweventextra(eventTitle, eventSummary, openFilePath, startDate, endDate, excludedDates, recIn)
	set calendarName to wireTapCalendarName()
	launchiCal()
	-- start time: 24 hours from now
	-- end time: 1 hour later
	--set eventStDate to date startDate
	--set eventEndDate to date endDate
	set eventStDate to startDate
	set eventEndDate to endDate
	
	set exDates to {}
	repeat with curDate in excludedDates
		--log curDate
		set exDates to exDates & {curDate}
	end repeat
	tell application "iCal"
		--activate
		set newEvent to (make new event at end of events of (first calendar whose title is calendarName) with properties {summary:(eventSummary as Unicode text), start date:eventStDate, end date:eventEndDate, description:eventTitle, excluded dates:exDates})
		if length of openFilePath is greater than 0 then
			make new open file alarm at end of open file alarms of newEvent with properties {trigger interval:-2, filepath:(openFilePath as Unicode text)}
		end if
		
		if length of recIn is greater than 0 then
			set recurrence of newEvent to recIn
		end if
		
		--show newEvent
		
		set eventStDate to start date of newEvent
		set eventEndDate to end date of newEvent
		
	end tell
	
	set startTranslated to convertDateToNumberList(eventStDate)
	set endTranslated to convertDateToNumberList(eventEndDate)
	
	tell application "iCal"
		return {(uid of newEvent), startTranslated, endTranslated, ((recurrence of newEvent) as Unicode text), ((filepath of (open file alarm of newEvent)) as Unicode text)}
	end tell
end makeneweventextra

on getUidWithPath(path)
	set wireTapEvents to getWireTapEvents()
	repeat with currentEvent in wireTapEvents
		tell application "iCal"
			set eventFileName to filepath of (open file alarm of currentEvent)
		end tell
		if ((path as Unicode text) is equal to (eventFileName as Unicode text)) then
			tell application "iCal"
				return (uid of currentEvent)
			end tell
		end if
	end repeat
	return "not found"
end getUidWithPath

-- get all event descriptions that have a file open alarm with the specified path
on getEventDescriptionsWithPath(filePath)
	set answer to {}
	set wireTapEvents to getWireTapEvents()
	repeat with currentEvent in wireTapEvents
		tell application "iCal"
			set curPath to filepath of (open file alarm of currentEvent)
		end tell
		if ((filePath as Unicode text) is equal to (curPath as Unicode text)) then
			tell application "iCal"
				set startDate to start date of currentEvent
				set endDate to end date of currentEvent
			end tell
			
			set startTranslated to convertDateToNumberList(startDate)
			set endTranslated to convertDateToNumberList(endDate)
			
			tell application "iCal"
				set curEventAnswer to {(uid of currentEvent), startTranslated, endTranslated, ((recurrence of currentEvent) as Unicode text), ((filepath of (open file alarm of currentEvent)) as Unicode text), ((summary of currentEvent) as Unicode text)}
				set excludedDates to (excluded dates of currentEvent)
				set answerExcDates to {}
			end tell
			repeat with curDate in excludedDates
				set dateTranslated to convertDateToNumberList(curDate)
				set answerExcDates to answerExcDates & {dateTranslated}
			end repeat
			tell application "iCal"
				set curEventAnswer to curEventAnswer & {answerExcDates}
				set answer to answer & {curEventAnswer}
			end tell
		end if
	end repeat
	return answer
end getEventDescriptionsWithPath

on checkReady(waitTime)
	tell application "iCal"
		try
			with timeout of waitTime seconds
				get calendars
			end timeout
		on error number num
			if num is -1712 then
				return false
			end if
		end try
		return true
	end tell
end checkReady


on bringiCalToFront()
	tell application "iCal"
		activate
	end tell
end bringiCalToFront
